package com.burhanstore.neonbubblequest;

import android.app.Application;
import android.app.Dialog;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;

import androidx.appcompat.app.AppCompatActivity;

import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.facebook.ads.AudienceNetworkAds;
import com.google.android.gms.ads.MobileAds;

public class GameController extends Application {

    private static GameController mInstance;
    public static final String TAG = GameController.class.getSimpleName();
    public static Dialog dialog;


    @Override
    public void onCreate() {
        super.onCreate();
        mInstance = this;
        game_intAdNetworks();
    }

    private void game_intAdNetworks() {
        MobileAds.initialize(this, initializationStatus -> {
        });

        AudienceNetworkAds.initialize(this);
        AppLovinSdk.getInstance(this).setMediationProvider("max");
        AppLovinSdk.initializeSdk(this, new AppLovinSdk.SdkInitializationListener() {
            @Override
            public void onSdkInitialized(final AppLovinSdkConfiguration configuration) {
                // AppLovin SDK is initialized, start loading ads
            }
        });
    }




    public static void init_dialog(AppCompatActivity activity) {
        dialog = new Dialog(activity);
        dialog.setCancelable(false);
        dialog.setContentView(R.layout.progress_dialog);
        dialog.getWindow().setBackgroundDrawable(new ColorDrawable
                (Color.TRANSPARENT));

    }

    public static void show_dialog() {
        try {
            if (!dialog.isShowing())
                dialog.show();
        } catch (Exception e) {
        }
    }

    public static void dismiss_dialog() {
        try {
            if (dialog.isShowing())
                dialog.dismiss();
        } catch (Exception e) {

        }

    }


}